import asyncio
from config_enum import scan_table_enum
from config_enum import filter_module_slider_enum
from py_pli.pylib import VUnits
from virtualunits.vu_scan_table import VUScanTable
from virtualunits.vu_filter_module_slider import VUFilterModuleSlider
from pylog.pylogger import PyLogger

# 2024-09-12 Copy from Hicham

async def test_barcode():
    await VUnits.instance.hal.StartupHardware()
    await VUnits.instance.hal.InitializeDevice()
    await VUnits.instance.hal.HomeMovers()

    scan_table:VUScanTable = VUnits.instance.hal.scan_table

    for i in range(50000):

        await scan_table.MoveToPos(scan_table_enum.Positions.PlateBCRLeft)
        barcode = await scan_table.ReadBarcode()
        PyLogger.logger.info(f">>>>>>>>>>>>>>>>>>>>>test_barcode: {i} : {barcode}")
        await asyncio.sleep(0.1)

# 2024-09-12 Kay add-ons

async def bc_cycle_test(reader_no = 2, cycles = 10, standby = 0.1):
    # barcode reader test with movement
    # reader_no: 1 = Filtermodule Reader
    #            2 = Scantable Plate BC Left Reader (Default)

    await VUnits.instance.hal.StartupHardware()
    await VUnits.instance.hal.InitializeDevice()
    await VUnits.instance.hal.HomeMovers()

    scan_table:VUScanTable = VUnits.instance.hal.scan_table
    filtermodule_slider:VUFilterModuleSlider = VUnits.instance.hal.filterModuleSlider
    

    if reader_no == 2:
        # Plate Barcode Reader

        await VUnits.instance.hal.plateDoor.Open()
        for i in range(cycles):

            reading_position = scan_table_enum.Positions.PlateBCRLeft
            intermediate_position = scan_table_enum.Positions.Wait
            print(reading_position)
            await scan_table.MoveToPos(reading_position)
            barcode = await scan_table.ReadBarcode()
            PyLogger.logger.info(f">>>>>>>>>>>>>>>>>>>>>test_barcode: {i} : {barcode}")
            await scan_table.MoveToPos(intermediate_position)
            await asyncio.sleep(standby)
        await VUnits.instance.hal.plateDoor.Close() 
    else:
        # Filtermodule Barcodereader

        for i in range(cycles):

            for j in range(6):
                await filtermodule_slider.SelectModuleForBC(j)
                barcode = await filtermodule_slider.ReadCurrentBarcode()
                PyLogger.logger.info(f">>>>>>>>>>>>>>>>>>>>>test_barcode: {i} : {barcode}")
                await asyncio.sleep(standby)
        await filtermodule_slider.Move(1)
        await filtermodule_slider.Home()

       
